program project1;
{$mode objfpc}{$H+}
uses
  CRT, FileUtil;
type
  PTree= ^Tree;  // Указатель на дерево
  Tree= record   // Само дерево, имеет тип - запись
  node: string;  // значение вершины (узла) дерева
  left: PTree; // Ссылка на левое поддерево
  right: PTree; // Ссылка на правое поддерево
  end;
var
  ptr_tree, current_tree, root: ^Tree;
  p, current: ^Tree;
  s: string;
  choose: integer;
{Прцедура поиска узла}
procedure search_node(Elem: string;
                      ptr_tree:PTree;
                      var current_tree:PTree);
var
  p: ^Tree;
begin
  p:= ptr_tree;
  writeln(p^.node);
  if not (p^.node = Elem) then
    begin
      if p^.left <> nil then
        search_node (Elem, p^.left, current_tree);
      if p^.right <> nil then
        search_node (Elem, p^.right, current_tree);
    end
  else current_tree:= p;
end;

{Процедура вывода дерева на экран}
procedure view_tree (ptr_tree: PTree);
var
  p: ^Tree;
begin
  p:= ptr_tree;
  writeln(p^.node);
  if p^.left <> nil then
    view_tree(p^.left);
  if p^.right <> nil then
    view_tree(p^.right);
end;

{Процедура удаления текущего поддерева}
procedure dispose_tree (ptr_tree:PTree);
var
  p: ^Tree;
begin
  if ptr_tree <> nil then
  begin
    p:= ptr_tree;
    writeln(p^.node);
    if p^.left <> nil then
    begin
      dispose_tree(p^.left);
    end;
    if p^.right <> nil then
    begin
      dispose_tree(p^.right);
    end;
    dispose(p);
  end
end;
procedure obhod(p: PTree);
begin
   if p <> nil then
   begin
      obhod(p^.left);
      write(p^.node, ' ');
      obhod(p^.right);
   end;
end;

begin
  writeln(UTF8ToConsole('введите номер или имя вершины'));
  readln(s);
  new(current);
  root:= current;
  current^.node:= s;
  current^.left:= nil;
  current^.right:= nil;
  repeat
    writeln;
    writeln(UTF8ToConsole('Корень текущего подерева: '),
            current^.node);
    writeln(UTF8ToConsole('Выберите нужное действие:'));
    writeln(UTF8ToConsole('1-ввод левого поддерева'));
    writeln(UTF8ToConsole('2-ввод правого поддерева'));
    writeln(UTF8ToConsole('3-сделать корень поддерева текущим'));
    writeln(UTF8ToConsole('4-просмотреть дерево'));
    writeln(UTF8ToConsole('5-удалить текущее поддерево'));
    writeln(UTF8ToConsole('6-обход дерева слева'));
    writeln(UTF8ToConsole('7-выход из программы'));
    readln(choose);
    case choose of
    1: begin {Создание левого поддерева}
         if current^.left= nil then
           new(p)
         else
           p:= current^.left;
         writeln(UTF8ToConsole('введите номер или имя вершины'));
         readln(s);
         p^.node:= s;
         p^.left:= nil;
         p^.right:= nil;
         current^.left:= p;
       end;
    2: begin {Создание правого поддерева}
         if current^.right= nil then
           new(p)
         else
           p:= current^.right;
         writeln(UTF8ToConsole('введите номер или имя вершины'));
         readln(s);
         p^.node:= s;
         p^.left:= nil;
         p^.right:= nil;
         current^.right:= p;
       end;
    3: begin {Поиск нужной вершины}
         writeln(UTF8ToConsole('введите номер или имя вершины'));
         readln(s);
         current_tree:= nil;
         ptr_tree:= root;
         search_node (s, ptr_tree, current_tree);
         if current_tree <> nil then
           current:= current_tree;
       end;
    4: begin {Вывод введенного дерева на экран}
         ptr_tree:= root;
         view_tree(ptr_tree);
       end;
    5: begin {Удаление поддерева}
         writeln(UTF8ToConsole('введите букву L для'));
         writeln(UTF8ToConsole('удаления левого поддерева'));
         writeln(UTF8ToConsole('или любой символ для'));
         writeln(UTF8ToConsole('удаления правого поддерева'));
         readln(s);
         if (s= 'l') or (s= 'L') then
         begin {Удаление левого поддерева}
           ptr_tree:= current^.left;
           current^.left:= nil;
           dispose_tree(ptr_tree);
         end
         else
         begin {Удаление правого поддерева}
           ptr_tree:= current^.right;
           current^.right:= nil;
           dispose_tree(ptr_tree);
         end;
       end;
    6: begin
         writeln(UTF8ToConsole('Обход двоичного дерева слева:'));
         writeln;
         obhod(root);
         writeln;
       end;
     end; { end of case }
  until choose = 7
end.


